/* UCIController */

#import <Cocoa/Cocoa.h>
#import "UCITask.h"

@interface UCIController : NSObject <UCITaskController>
{
   IBOutlet NSTextField *nameField;
   IBOutlet NSTextField *codeField;
   IBOutlet NSTextView  *uciLog;

   UCITask *engineTask1;
   UCITask *engineTask2;
   NSFileHandle *logFile;
}

- (IBAction)doRegister:(id)sender;
- (IBAction)doCancel:(id)sender;

- (void)launchEngine:(char *)enginePath;
- (void)sendToEngine:(char *)uciMsg;
- (void)quitEngine;
- (void)quitEngine2;
- (void)swapEngine;

- (void)alertRegDidEnd:(NSAlert *)alert returnCode:(NSInteger)returnCode contextInfo:(void *)contextInfo;
- (void)alertUnregDidEnd:(NSAlert *)alert returnCode:(NSInteger)returnCode contextInfo:(void *)contextInfo;

@end
